<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


header('Content-type: application/json; charset=utf-8');
date_default_timezone_set('Africa/Accra');

require_once "database.php";
require_once "laspse_function.php"; // <- make sure this file exists and contains abraboIsPolicyLapsed()

$policy_number = trim($_REQUEST['policy_number'] ?? '');
if ($policy_number === '') {
  echo json_encode(["ok"=>false,"error"=>"policy_number is required"]);
  exit;
}

$policy_number = htmlspecialchars(filter_var(
  mysqli_real_escape_string($con, $policy_number),
  FILTER_SANITIZE_STRING
));

/**
 * Get policy + premium by policy_number
 */
$result_policy = mysqli_query($con,"
  SELECT set_premium, policy_number
  FROM policy_details_view
  WHERE policy_number = '$policy_number'
  LIMIT 1
");

if (!$result_policy) {
  echo json_encode(["ok"=>false,"error"=>"Policy query failed","details"=>$con->error]);
  exit;
}

$test_policy = mysqli_fetch_assoc($result_policy);
if (!$test_policy) {
  echo json_encode(["ok"=>false,"error"=>"No policy found for this mobile number"]);
  exit;
}

$policy_number = trim($test_policy['policy_number']);
$set_premium   = trim($test_policy['set_premium']);

/**
 * Search Cover by matching premium
 */
$result_cover = mysqli_query($con,"
  SELECT sum_assured
  FROM cover_levels
  WHERE premium_main_life = '$set_premium'
     OR premium_main_plus_one_parent = '$set_premium'
     OR premium_main_plus_two_parents = '$set_premium'
  LIMIT 1
");

if (!$result_cover) {
  echo json_encode(["ok"=>false,"error"=>"Cover query failed","details"=>$con->error]);
  exit;
}

$test_cover = mysqli_fetch_assoc($result_cover);
$sum_assured = $test_cover ? trim($test_cover['sum_assured']) : null;

/**
 * Policy status (real time)
 */
$asAtDate = date('Y-m-d');

// IMPORTANT: use $policy_number (not $policyNumber)
$result = abraboIsPolicyLapsed($con, $policy_number, $asAtDate);

$policy_status = "UNKNOWN";
if (($result["ok"] ?? false) === true) {
  $policy_status = ($result["is_lapsed"] ?? true) ? "LAPSED" : "ACTIVE";
} else {
  $policy_status = "UNKNOWN";
}

/**
 * Total paid
 */
$result_paid = mysqli_query($con,"
  SELECT IFNULL(SUM(amount),0) AS total_paid
  FROM premium_transactions
  WHERE policy_number = '$policy_number'
");

if (!$result_paid) {
  echo json_encode(["ok"=>false,"error"=>"Paid query failed","details"=>$con->error]);
  exit;
}

$test_paid = mysqli_fetch_assoc($result_paid);
$sum_paid = $test_paid ? (float)$test_paid['total_paid'] : 0;

/**
 * Response
 */
$response = [
  "ok" => true,
  "policy_number" => $policy_number,
  "status" => $policy_status,
  "cover" => $sum_assured,
  "premium" => (float)$set_premium,
  "paid" => $sum_paid,
];

echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
?>