<?php
// Calling database connection
//Connect to Database
include("database.php");
include('session.php');
include('log_functions.php');
require_once('crypto_functions.php');

// Ensure the ID is set and properly sanitized
if (isset($_REQUEST['idcode'])) {
    $idn = $_REQUEST['idcode'];

    // Decrypt the ID
$id = !empty($idn) ? decrypt($idn) : '';
$id = urlencode($id);


    // Validate the ID (Ensure it's numeric to prevent SQL injection)
    if (!is_numeric($id)) {
        die("Invalid ID provided");
    }
    
    // Sanitize the user index
    $userindex = htmlspecialchars($_SESSION['userindex'], ENT_QUOTES, 'UTF-8');
    
    // Use prepared statements for SQL query to prevent SQL injection
    $stmt = $con->prepare("DELETE FROM cover_levels WHERE cover_level_id = ?");
    if ($stmt === false) {
        die("Error preparing the statement: " . $con->error);
    }
    
    // Bind the parameters
    $stmt->bind_param('i', $id); // 'i' indicates that the parameter is an integer
    
    // Execute the query
    if ($stmt->execute()) {
        // Call the log function after successful deletion
        $page_path = 'parameters_delete.php';
        $reasons = 'Deleted Successfully';
        $data_inf = 'N/A';
        log_failed_login($con, $userindex, $page_path, $reasons ,$data_inf);
        
        // Redirect with success message
        header("Location: parameters_report.php?sr=018!b112&msg=10$296?c");
    } else {
        die("Error executing the query: " . $stmt->error);
    }

    // Close the prepared statement
    $stmt->close();
} else {
    die("No ID provided");
}
?>
