<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
//include("session.php");

// Include the database connection
//Connect to Database
include("database.php");
include('log_functions.php');

session_start();

// Function to escape user input
function escape($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}



// Sanitize user input securely
$product_name       = filter_input(INPUT_POST, 'product_name', FILTER_SANITIZE_STRING);
$product_description   = filter_input(INPUT_POST, 'product_description', FILTER_SANITIZE_STRING);
$product_num_code    = filter_input(INPUT_POST, 'product_num_code', FILTER_SANITIZE_STRING);
$product_num_date    = filter_input(INPUT_POST, 'product_num_date', FILTER_SANITIZE_STRING);
$product_num_gen     = filter_input(INPUT_POST, 'product_num_gen', FILTER_SANITIZE_STRING);
$userindex         = filter_input(INPUT_POST, 'userindex', FILTER_SANITIZE_STRING);
$product_index         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_STRING);


// Sanitize and format dates
$inputdate = date("Y-m-d H:i:s"); 

// Validate the input data (use appropriate checks for each field here if needed)

// Prepare and bind the update query securely
$stmt = $con->prepare("
    UPDATE product 
    SET 
        product_name = ?, 
        product_description = ?, 
        product_userindex = ?, 
        product_inputdate = ?, 
        product_num_code = ?, 
        product_num_date = ?, 
        product_num_gen = ?
    WHERE product_index = ?
");

// Bind parameters to the query (8 placeholders = 8 "s")
$stmt->bind_param(
    "ssssssss", 
    $product_name, 
    $product_description, 
    $userindex, 
    $inputdate, 
    $product_num_code, 
    $product_num_date,
    $product_num_gen,
    $product_index
);


// Call the log_failed_login function
$page_path = 'product_edit.php';
$reasons = 'Updated Successfully';
$data_inf = 'N/A';
log_failed_login($con, $userindex, $page_path, $reasons ,$data_inf);

// Execute the query
if ($stmt->execute()) {
    // Redirect on success
    header("Location: product_report.php?sr=018!b110&msg=10$205?c");
    exit;
} else {
    // Handle failure (log error, redirect to an error page)
    error_log("Error executing query: " . $stmt->error);
    header("Location: error_page.php");
    exit;
}

// Close the statement and connection
$stmt->close();
$con->close();
?>
