<?php
include("database.php");
include('log_functions.php');	
session_start();

// Check user session for authentication
if (!isset($_SESSION['userindex'])) {
    die("Unauthorized access.");
}

// Escape output function
function escape($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

// Sanitize and validate inputs (FILTER_SANITIZE_STRING is deprecated)
function clean_input($data) {
    return trim(strip_tags($data));
}

$product_name        = clean_input($_POST['product_name'] ?? '');
$product_description = clean_input($_POST['product_description'] ?? '');
$product_num_code    = clean_input($_POST['product_num_code'] ?? '');
$product_num_date    = clean_input($_POST['product_num_date'] ?? '');
$product_num_gen     = clean_input($_POST['product_num_gen'] ?? '');
$userindex           = $_SESSION['userindex']; // From session

$inputdate = date("Y-m-d H:i:s");

// Prepare statement
$stmt = $con->prepare("
    INSERT INTO product (
        product_name,
        product_description,
        product_userindex,
        product_inputdate,
        product_num_code,
        product_num_date,
        product_num_gen
    ) VALUES (?, ?, ?, ?, ?, ?, ?)
");

if (!$stmt) {
    error_log("Prepare failed: " . $con->error);
    die("An internal error occurred. Please try again later.");
}

// Bind parameters
$stmt->bind_param(
    "sssssss",
    $product_name,
    $product_description,
    $userindex,
    $inputdate,
    $product_num_code,
    $product_num_date,
    $product_num_gen
);

// Execute the statement and handle errors securely
if ($stmt->execute()) {
    // Log success (rename function for clarity)
    $page_path = 'product_add.php';
    $reasons   = 'Product added successfully';
    $data_inf = 'N/A';
    log_failed_login($con, $userindex, $page_path, $reasons ,$data_inf); // <- Consider renaming this function

    // Redirect on success
    header("Location: product_report.php?sr=018!b110&msg=10$909?c");
    exit;
} else {
    error_log("Database error: " . $stmt->error);
    die("An error occurred while processing your request. Please try again later.");
}

$stmt->close();
?>
