<?php
include("database.php");
include("session.php");

date_default_timezone_set("Africa/Accra");

// Session
$userindex     = isset($_SESSION['userindex']) ? (int)$_SESSION['userindex'] : 0;
$user_sub_priv = isset($_SESSION['user_sub_priv']) ? trim($_SESSION['user_sub_priv']) : '';

// Defaults
$date_from = date('Y-m-01');
$date_to   = date('Y-m-d');
$srn       = isset($srn) ? $srn : '';



// Fetch Users (for dropdown) - only priv 106
$users = [];
$stmtUsers = $con->prepare("
  SELECT userindex, user_surname, user_othernames, user_sub_priv
  FROM users
  WHERE user_sub_priv = ?
  ORDER BY user_surname ASC, user_othernames ASC
");
$priv = '106';
if ($stmtUsers) {
    $stmtUsers->bind_param("s", $priv);
    $stmtUsers->execute();
    $resUsers = $stmtUsers->get_result();
    while ($row = $resUsers->fetch_assoc()) {
        $users[] = $row;
    }
    $stmtUsers->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <link rel="apple-touch-icon" sizes="76x76" href="../assets/img/apple-icon.png">
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>Report Filter</title>
  <meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no" name="viewport" />

  <!-- Material Dashboard CSS -->
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <link href="../assets/demo/demo.css" rel="stylesheet" />

  <style>
    body{
      font-family: Arial, sans-serif;
      margin:0;
      color:#333;
      background:url('images/ayo_banner4.png') center/cover no-repeat fixed;
    }
    body::before{
      content:"";
      position:fixed;
      inset:0;
      background:url('images/ayo_banner4.png') center/cover no-repeat fixed;
      opacity:0.35;
      z-index:-1;
    }
    .card{
      border-radius:12px;
      box-shadow:0 6px 18px rgba(0,0,0,0.12);
    }
    .card-header-primary{
      background:linear-gradient(60deg, #6ec1e4, #2a89c9) !important;
      color:#fff;
      text-align:center;
      padding:18px 15px;
      border-radius:12px 12px 0 0;
    }
    .card-header-primary h4, .card-header-primary p{
      margin:0;
      color:#fff;
    }
    .card-header-primary p{
      margin-top:6px;
      opacity:0.9;
      font-weight:500;
    }
    .form-control{
      border-radius:8px;
      border:1px solid #dcdcdc;
      padding:10px 12px;
      width:100%;
    }
    .btn-primary{
      background:#2a89c9 !important;
      border:none !important;
      padding:12px 18px !important;
      border-radius:10px !important;
      font-weight:600 !important;
    }
    .btn-primary:hover{ background:#1f6fa6 !important; }

    /* Hidden sections */
    .conditional-wrap{ display:none; }
  </style>

  <script>
    function toggleConditionalFields(form) {
      const reportValue = form.select_report.value;

      const statusWrap = document.getElementById('status_wrap');
      const userWrap   = document.getElementById('user_wrap');

      if (reportValue === "1") {
        statusWrap.style.display = "block";
        userWrap.style.display   = "block";
      } else {
        statusWrap.style.display = "none";
        userWrap.style.display   = "none";

        if (form.payment_status) form.payment_status.value = "";
        if (form.selected_user)  form.selected_user.value  = "";
      }
    }

    function validateForm(form) {
      if (!form.date_from.value) {
        alert("Please select Date From.");
        form.date_from.focus();
        return false;
      }

      if (!form.date_to.value) {
        alert("Please select Date To.");
        form.date_to.focus();
        return false;
      }

      if (!form.select_report.value) {
        alert("Please select a Report Type.");
        form.select_report.focus();
        return false;
      }

      if (form.date_from.value > form.date_to.value) {
        alert("Date From cannot be greater than Date To.");
        form.date_from.focus();
        return false;
      }

      if (form.select_report.value === "1") {
        if (!form.payment_status.value) {
          alert("Please select a Status (Failed, Pending, or Success).");
          form.payment_status.focus();
          return false;
        }

        if (!form.selected_user.value) {
          alert("Please select a User.");
          form.selected_user.focus();
          return false;
        }
      }

      return confirm("Are you sure you want to proceed?");
    }

    document.addEventListener('DOMContentLoaded', function () {
      const form = document.forms['reportForm'];
      if (form) toggleConditionalFields(form);
    });
  </script>
</head>

<body>
<?php include 'main_menu_app.php'; ?>

<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-8">

        <div class="card">
          <div class="card-header card-header-primary">
            <h4 class="card-title">Report Filter</h4>
            <p class="card-category">Select a date range, report type, and filters to continue.</p>
          </div>

          <div class="card-body">
            <!-- selected_user is already posted because it is inside this POST form -->
            <form id="reportForm" name="reportForm" method="post" action="generate_report.php" onsubmit="return validateForm(this);">

              <div class="row">
                <div class="col-md-4">
                  <div class="form-group">
                    <label><b>Date From</b></label>
                    <input type="date" name="date_from" class="form-control" value="<?php echo htmlspecialchars($date_from); ?>" required>
                  </div>
                </div>

                <div class="col-md-4">
                  <div class="form-group">
                    <label><b>Date To</b></label>
                    <input type="date" name="date_to" class="form-control" value="<?php echo htmlspecialchars($date_to); ?>" required>
                    <input type="hidden" name="srn" value="<?php echo htmlspecialchars($srn); ?>">
                  </div>
                </div>

                <div class="col-md-4">
                  <div class="form-group">
                    <label><b>Report Type</b></label>
                    <select name="select_report" class="form-control" required onchange="toggleConditionalFields(this.form);">
                      <option value="">Select Report Type</option>
                      <?php
                      if ($user_sub_priv === '106' || $user_sub_priv === '107') {
                          echo '<option value="1">Subscriptions Report</option>';
                      }
                      ?>
                    </select>
                  </div>
                </div>
              </div>

              <!-- Status -->
              <div class="row conditional-wrap" id="status_wrap">
                <div class="col-md-4">
                  <div class="form-group">
                    <label><b>Status</b></label>
                    <select name="payment_status" class="form-control">
                      <option value="">Select Status</option>
                      <option value="ALL">All Status</option>';
                      <option value="Failed">Failed</option>
                      <option value="Pending">Pending</option>
                      <option value="Success">Success</option>
                    </select>
                  </div>
                </div>
              </div>
<?php
if ($user_sub_priv != '106') {
    echo '<div class="row conditional-wrap" id="user_wrap">
            <div class="col-md-6">
              <div class="form-group">
                <label><b>Select User</b></label>
                <select name="selected_user" id="selected_user" class="form-control">
                  <option value="">-- Select User --</option>
                  <option value="ALL">All Users</option>';

    if (!empty($users)) {
        foreach ($users as $u) {
            echo '<option value="'.htmlspecialchars($u['userindex']).'">'
               . htmlspecialchars(trim($u['user_surname'].' '.$u['user_othernames']))
               . '</option>';
        }
    } else {
        echo '<option value="" disabled>No users found</option>';
    }

    echo '      </select>
              </div>
            </div>
          </div>';
}
?>


              <div class="text-end">
                <button type="submit" class="btn btn-primary">Search</button>
              </div>

            </form>

            <!-- OPTIONAL: Quick note -->
         

          </div>
        </div>

      </div>
    </div>
  </div>
</div>

<!-- Scripts -->
<script src="../assets/js/core/jquery.min.js"></script>
<script src="../assets/js/core/popper.min.js"></script>
<script src="../assets/js/core/bootstrap-material-design.min.js"></script>
<script src="../assets/js/plugins/perfect-scrollbar.jquery.min.js"></script>
<script src="../assets/js/plugins/moment.min.js"></script>
<script src="../assets/js/plugins/sweetalert2.js"></script>
<script src="../assets/js/plugins/jquery.validate.min.js"></script>
<script src="../assets/js/plugins/jquery.bootstrap-wizard.js"></script>
<script src="../assets/js/plugins/bootstrap-selectpicker.js"></script>
<script src="../assets/js/plugins/bootstrap-datetimepicker.min.js"></script>
<script src="../assets/js/plugins/jquery.dataTables.min.js"></script>
<script src="../assets/js/plugins/bootstrap-tagsinput.js"></script>
<script src="../assets/js/plugins/jasny-bootstrap.min.js"></script>
<script src="../assets/js/plugins/fullcalendar.min.js"></script>
<script src="../assets/js/plugins/jquery-jvectormap.js"></script>
<script src="../assets/js/plugins/nouislider.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/core-js/2.4.1/core.js"></script>
<script src="../assets/js/plugins/arrive.min.js"></script>
<script src="https://maps.googleapis.com/maps/api/js?key=YOUR_KEY_HERE"></script>
<script src="../assets/js/plugins/chartist.min.js"></script>
<script src="../assets/js/plugins/bootstrap-notify.js"></script>
<script src="../assets/js/material-dashboard.js?v=2.1.1" type="text/javascript"></script>
<script src="../assets/demo/demo.js"></script>

</body>
</html>
