<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


// Include database connection
include("database.php");
include("sms_function.php");
include("session.php");


// Get user index (assume numeric)
$userindex = isset($_SESSION['userindex']) ? (int)$_SESSION['userindex'] : 0;



// Initialize variables
$policy_details = null;
$error_message = "";
$success_message = "";
$search_value = "";

// Process search form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['search_policy'])) {
        $search_value = trim($_POST['policy_number'] ?? '');
        
        if (!empty($search_value)) {
            $search_value = $con->real_escape_string($search_value);
            
            // Search in policy_details_view
            $sql = "SELECT * FROM policy_details_view WHERE policy_number = '$search_value'";
            $result = $con->query($sql);
            
            if ($result->num_rows > 0) {
                $policy_details = $result->fetch_assoc();
                
                // Check if policy is already cancelled
                if ($policy_details['policy_status'] == 'CANCELLED') {
                    $error_message = "This policy has already been cancelled.";
                    $policy_details = null;
                }
            } else {
                $error_message = "No policy found with policy number: " . htmlspecialchars($search_value);
            }
        } else {
            $error_message = "Please enter a policy number to search.";
        }
    }
    
    // Process cancellation form submission
    if (isset($_POST['submit_cancellation'])) {
        $policyholder_id = $_POST['policyholder_id'] ?? '';
        $policy_number = $_POST['policy_number'] ?? '';
        $request_channel = $_POST['request_channel'] ?? '';
        $cancellation_reason = $_POST['cancellation_reason'] ?? '';
        $reason_notes = $_POST['reason_notes'] ?? '';
        $effective_date = $_POST['effective_date'] ?? '';
        $mobile_money_number = $_POST['mobile_money_number'] ?? '';
        
        
        // Validate required fields
        $required_fields = ['policyholder_id', 'policy_number', 'request_channel', 'cancellation_reason', 'effective_date'];
        $missing_fields = [];
        
        foreach ($required_fields as $field) {
            if (empty($$field)) {
                $missing_fields[] = ucfirst(str_replace('_', ' ', $field));
            }
        }
        
        if (empty($missing_fields)) {
            // Get current user from session
            $userindex = $_SESSION['userindex'] ?? 1;
            
            // Insert cancellation request
            $insert_sql = "INSERT INTO policy_cancellations 
                          (policyholder_id, policy_number, request_channel, cancellation_reason, 
                           reason_notes, request_date, effective_date, status, userindex, created_at)
                          VALUES (?, ?, ?, ?, ?, CURDATE(), ?, 'Pending', ?, NOW())";
            
            $stmt = $con->prepare($insert_sql);
            
            $stmt->bind_param("isssssi", 
                $policyholder_id,
                $policy_number,
                $request_channel,
                $cancellation_reason,
                $reason_notes,
                $effective_date,
                $userindex
            );
            
            if ($stmt->execute()) {
                $cancellation_id = $stmt->insert_id;
                $success_message = "Cancellation request submitted successfully! Reference ID: CAN-" . str_pad($cancellation_id, 6, '0', STR_PAD_LEFT);
                
                // Clear search results
                $policy_details = null;
                $search_value = "";
//=================================
//cancelled Policy
$policy_status = 'CANCELLED';
$sql = "
    UPDATE policy_holders 
    SET policy_status = ?
    WHERE policy_number = ?
";
$stmt = $con->prepare($sql);
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
$stmt->bind_param(
    "ss",
    $policy_status,
    $policy_number
);
$stmt->execute();
$stmt->close();
//=============SMS
$mobile = preg_replace('/^233/', '0', $mobile_money_number);

$user_id = $userindex; // session userindex
//$mobile  = "0244229547";

$result = sendHubtelSms(
    $con,
    $user_id,
    $mobile,
    "ImpactLife: Your insurance policy has been cancelled. Coverage ended. Contact +233596922343 For Support.",
    "Cancel_Pol"
);

if ($result["success"]) {
    //echo "SMS sent successfully";
} else {
    echo "SMS failed<br>";
    echo "HTTP Code: " . $result["http_code"] . "<br>";
    echo "Error: " . $result["curl_error"] . "<br>";
    echo "Response: " . $result["response"];
}


//==========================================   

            } else {
                $error_message = "Error submitting cancellation request: " . $con->error;
            }
            //$stmt->close();
        } else {
            $error_message = "Please fill in all required fields: " . implode(', ', $missing_fields);
        }
    }
}





?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Policy Cancellation</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Datepicker CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/css/bootstrap-datepicker.min.css">
    

<?php include 'main_menu_app.php'; ?>
<style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}


</style>
    <style>
        :root {
            --primary-color: #6ec1e4;
            --primary-dark: #4fa8d1;
            --secondary-color: #0a2cea;
            --danger-color: #dc3545;
            --warning-color: #ffc107;
            --success-color: #28a745;
            --light-bg: #f5f5f5;
            --card-shadow: 0 4px 20px 0 rgba(0,0,0,.14), 0 7px 10px -5px rgba(110,193,228,.4);
        }
        
        body {
            background-color: #f5f5f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding-top: 20px;
        }
        
        .card-header-primary {
            background: linear-gradient(60deg, var(--primary-color), var(--secondary-color)) !important;
            color: white !important;
        }
        
        .search-btn {
            background: linear-gradient(60deg, var(--primary-color), var(--primary-dark));
            color: white;
            border: none;
            padding: 10px 30px;
            border-radius: 30px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .search-btn:hover {
            background: linear-gradient(60deg, var(--primary-dark), var(--primary-color));
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        }
        
        .cancel-btn {
            background: linear-gradient(60deg, var(--danger-color), #c82333);
            color: white;
            border: none;
            padding: 12px 40px;
            border-radius: 30px;
            font-weight: 600;
            font-size: 1.1em;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(220, 53, 69, 0.3);
        }
        
        .cancel-btn:hover {
            background: linear-gradient(60deg, #c82333, var(--danger-color));
            transform: translateY(-3px);
            box-shadow: 0 6px 20px rgba(220, 53, 69, 0.4);
        }
        
        .form-card {
            box-shadow: var(--card-shadow);
            border-radius: 15px;
            border: none;
            overflow: hidden;
            margin-bottom: 30px;
        }
        
        .policy-card {
            box-shadow: 0 2px 15px rgba(0,0,0,0.08);
            border-radius: 12px;
            border: none;
            margin-bottom: 30px;
            overflow: hidden;
        }
        
        .policy-header {
            background: linear-gradient(135deg, #f8f9fa, #e9f7fe);
            padding: 25px;
            border-bottom: 3px solid var(--primary-color);
        }
        
        .policy-number {
            color: var(--secondary-color);
            font-weight: 700;
            font-size: 1.8em;
            margin: 0;
        }
        
        .policyholder-name {
            color: #333;
            font-weight: 700;
            font-size: 2em;
            margin: 10px 0 5px 0;
        }
        
        .policy-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 20px;
            padding: 25px;
        }
        
        .policy-item {
            background: white;
            padding: 20px;
            border-radius: 10px;
            border-left: 4px solid var(--primary-color);
            box-shadow: 0 3px 10px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
        }
        
        .policy-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0,0,0,0.1);
        }
        
        .item-label {
            font-size: 0.85em;
            color: #666;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 8px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .item-value {
            font-size: 1.2em;
            color: #333;
            font-weight: 500;
            padding-left: 26px;
        }
        
        .status-badge {
            font-size: 0.85em;
            padding: 8px 20px;
            border-radius: 20px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .badge-active {
            background-color: rgba(40, 167, 69, 0.15);
            color: var(--success-color);
            border: 2px solid rgba(40, 167, 69, 0.3);
        }
        
        .badge-cancelled {
            background-color: rgba(220, 53, 69, 0.15);
            color: var(--danger-color);
            border: 2px solid rgba(220, 53, 69, 0.3);
        }
        
        .badge-pending {
            background-color: rgba(255, 193, 7, 0.15);
            color: #856404;
            border: 2px solid rgba(255, 193, 7, 0.3);
        }
        
        .form-section {
            background: white;
            padding: 30px;
            border-radius: 12px;
            margin: 25px;
            border: 1px solid #f0f0f0;
        }
        
        .section-title {
            color: var(--secondary-color);
            border-bottom: 2px solid #f0f0f0;
            padding-bottom: 15px;
            margin-bottom: 25px;
            font-weight: 700;
            font-size: 1.4em;
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            margin-right: 12px;
            font-size: 1.3em;
        }
        
        .required:after {
            content: " *";
            color: var(--danger-color);
            font-weight: bold;
        }
        
        .form-label {
            font-weight: 600;
            color: #555;
            margin-bottom: 10px;
            display: block;
            font-size: 1.1em;
        }
        
        .form-control, .form-select {
            border: 2px solid #e9ecef;
            border-radius: 8px;
            padding: 12px 15px;
            font-size: 1em;
            transition: all 0.3s ease;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(110, 193, 228, 0.25);
        }
        
        .select-wrapper {
            position: relative;
        }
        
        .select-wrapper:after {
            content: '\f078';
            font-family: 'Font Awesome 5 Free';
            font-weight: 900;
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--primary-color);
            pointer-events: none;
        }
        
        .form-select {
            appearance: none;
            padding-right: 50px;
        }
        
        textarea.form-control {
            min-height: 120px;
            resize: vertical;
        }
        
        .alert-custom {
            border-radius: 10px;
            border: none;
            box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        }
        
        .info-hint {
            font-size: 0.9em;
            color: #6c757d;
            margin-top: 8px;
            font-style: italic;
        }
        
        .datepicker-icon {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--primary-color);
            pointer-events: none;
        }
        
        .date-input-wrapper {
            position: relative;
        }
        
        .warning-box {
            background: linear-gradient(135deg, #fff3cd, #ffeaa7);
            border: 2px solid #ffc107;
            border-radius: 10px;
            padding: 25px;
            margin-bottom: 30px;
        }
        
        .warning-icon {
            color: #856404;
            font-size: 2.5em;
            margin-right: 20px;
        }
        
        .no-results {
            text-align: center;
            padding: 60px 20px;
            color: #666;
        }
        
        .no-results i {
            font-size: 4em;
            color: #dee2e6;
            margin-bottom: 20px;
        }
        
        .form-check-input:checked {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }
        
        .back-btn {
            background: linear-gradient(60deg, var(--primary-color), var(--primary-dark));
            color: white;
            border: none;
            padding: 10px 25px;
            border-radius: 25px;
            font-weight: 600;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        
        .back-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(110, 193, 228, 0.4);
            color: white;
            text-decoration: none;
        }
        
        .info-panel {
            background: linear-gradient(135deg, #e3f2fd, #bbdefb);
            border-radius: 10px;
            padding: 20px;
            margin-top: 20px;
        }
        
        .processing-time {
            font-size: 1.1em;
            color: #1565c0;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <!-- Search Card -->
                    <div class="card form-card">
                        <div class="card-header card-header-primary" style="text-align: center; padding: 25px;">
                            <h4 class="card-title" style="color:white; font-weight: bold; font-size: 1.8em;">
                                <i class="fas fa-ban"></i> POLICY CANCELLATION SYSTEM
                            </h4>
                            <p class="card-category" style="color: rgba(255,255,255,0.9); font-size: 1.1em;">
                                Search and cancel insurance policies
                            </p>
                        </div>
                        
                        <div class="card-body" style="padding: 30px;">
                            <!-- Search Form -->
                            <form method="POST" action="">
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="form-group mb-4">
                                            <label for="policy_number" class="form-label required">
                                                <i class="fas fa-file-contract me-2"></i>Enter Policy Number
                                            </label>
                                            <input type="text" 
                                                   class="form-control form-control-lg" 
                                                   id="policy_number" 
                                                   name="policy_number" 
                                                   placeholder="Example: ABR01260000010" 
                                                   value="<?= htmlspecialchars($search_value) ?>"
                                                   required
                                                   style="font-size: 1.1em;">
                                            <div class="info-hint">
                                                Enter the exact policy number as shown on the policy document
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="form-group mb-4 d-flex align-items-end">
                                            <button type="submit" name="search_policy" value="1" class="btn search-btn w-100" style="padding: 15px;">
                                                <i class="fas fa-search me-2"></i> SEARCH POLICY
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            
                            <!-- Messages -->
                            <?php if (!empty($error_message)): ?>
                                <div class="alert alert-danger alert-custom mt-4">
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-exclamation-triangle fa-2x me-3"></i>
                                        <div>
                                            <h5 class="mb-1">Error</h5>
                                            <p class="mb-0"><?= htmlspecialchars($error_message) ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (!empty($success_message)): ?>
                                <div class="alert alert-success alert-custom mt-4">
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-check-circle fa-2x me-3"></i>
                                        <div>
                                            <h5 class="mb-1">Success</h5>
                                            <p class="mb-0"><?= htmlspecialchars($success_message) ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Policy Details Display -->
                    <?php if ($policy_details): ?>
                    <div class="card policy-card">
                        <!-- Policy Header -->
                        <div class="policy-header">
                            <div class="d-flex justify-content-between align-items-center flex-wrap">
                                <div>
                                    <h1 class="policyholder-name">
                                        <?= htmlspecialchars($policy_details['full_name']) ?>
                                    </h1>
                                    <p class="policy-number">
                                        <i class="fas fa-file-alt me-2"></i>
                                        <?= htmlspecialchars($policy_details['policy_number']) ?>
                                    </p>
                                </div>                                
                            </div>
                        </div>
                        
                        <!-- Policy Details Grid -->
                        <div class="policy-grid">
                            <div class="policy-item">
                                <div class="item-label">
                                    <i class="fas fa-id-card"></i> Policyholder ID
                                </div>
                                <div class="item-value">
                                    <?= htmlspecialchars($policy_details['policyholder_id']) ?>
                                </div>
                            </div>
                            
                            <div class="policy-item">
                                <div class="item-label">
                                    <i class="fas fa-venus-mars"></i> Gender
                                </div>
                                <div class="item-value">
                                    <?= htmlspecialchars($policy_details['gender']) ?>
                                </div>
                            </div>
                            
                            <div class="policy-item">
                                <div class="item-label">
                                    <i class="fas fa-mobile-alt"></i> Mobile Number
                                </div>
                                <div class="item-value">
                                    <?= htmlspecialchars($policy_details['mobile_money_number']) ?>
                                </div>
                            </div>
                            
                            <div class="policy-item">
                                <div class="item-label">
                                    <i class="fas fa-wifi"></i> Mobile Network
                                </div>
                                <div class="item-value">
                                    <?= htmlspecialchars($policy_details['momo_network']) ?>
                                </div>
                            </div>
                            
                            <div class="policy-item">
                                <div class="item-label">
                                    <i class="fas fa-cube"></i> Product Name
                                </div>
                                <div class="item-value">
                                    <?= htmlspecialchars($policy_details['product_name']) ?>
                                </div>
                            </div>                           
                           
                        </div>
                        
                        <!-- Cancellation Form Section -->
                        <div class="form-section">
                            <!-- Warning Notice -->
                            <div class="warning-box d-flex align-items-start">
                                <i class="fas fa-exclamation-triangle warning-icon"></i>
                                <div>
                                    <h4 class="mb-3" style="color: #856404;">
                                        <strong>IMPORTANT CANCELLATION NOTICE</strong>
                                    </h4>
                                    <p class="mb-2">
                                        <i class="fas fa-times-circle me-2 text-danger"></i>
                                        Cancelling this policy will terminate all coverage immediately upon effective date.
                                    </p>
                                    <p class="mb-2">
                                        <i class="fas fa-money-bill-wave me-2 text-danger"></i>
                                        Any unused premiums will be forfeited according to policy terms and conditions.
                                    </p>
                                    <p class="mb-0">
                                        <i class="fas fa-exclamation me-2 text-danger"></i>
                                        This action cannot be undone. Please ensure all information is correct before proceeding.
                                    </p>
                                </div>
                            </div>
                            
                            <h5 class="section-title">
                                <i class="fas fa-file-contract"></i> CANCELLATION REQUEST FORM
                            </h5>
                            
                            <form method="POST" action="">
                                <!-- Hidden fields for policy information -->
                                <input type="hidden" name="policyholder_id" value="<?= htmlspecialchars($policy_details['policyholder_id']) ?>">
                                <input type="hidden" name="policy_number" value="<?= htmlspecialchars($policy_details['policy_number']) ?>">
                                <input type="hidden" name="mobile_money_number" value="<?= htmlspecialchars($policy_details['mobile_money_number']) ?>">
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <!-- Request Channel -->
                                        <div class="form-group mb-4">
                                            <label for="request_channel" class="form-label required">
                                                <i class="fas fa-sign-in-alt me-2"></i>Request Channel
                                            </label>
                                            <div class="select-wrapper">
                                                <select class="form-select" id="request_channel" name="request_channel" required>
                                                    <option value="">Select Channel</option>
                                                    <option value="USSD">USSD Code (*170#)</option>
                                                    <option value="Mobile App">Mobile Application</option>
                                                    <option value="Call Center">Call Center</option>
                                                    <option value="Branch Office">Branch Office</option>
                                                    <option value="Agent">Insurance Agent</option>
                                                    <option value="Online Portal">Online Customer Portal</option>
                                                    <option value="Email">Email Request</option>
                                                    <option value="SMS">SMS Request</option>
                                                </select>
                                            </div>
                                            <div class="info-hint">How was this cancellation request made?</div>
                                        </div>
                                        
                                        <!-- Cancellation Reason -->
                                        <div class="form-group mb-4">
                                            <label for="cancellation_reason" class="form-label required">
                                                <i class="fas fa-comment-dots me-2"></i>Cancellation Reason
                                            </label>
                                            <div class="select-wrapper">
                                                <select class="form-select" id="cancellation_reason" name="cancellation_reason" required>
                                                    <option value="">Select Reason</option>
                                                    <option value="Financial Constraints">Financial Constraints</option>
                                                    <option value="Found Better Alternative">Found Better Insurance Alternative</option>
                                                    <option value="Dissatisfied with Service">Dissatisfied with Service</option>
                                                    <option value="Policy No Longer Needed">Policy No Longer Needed</option>
                                                    <option value="Moving Abroad">Moving Abroad / Relocation</option>
                                                    <option value="Deceased">Policyholder Deceased</option>
                                                    <option value="Duplicate Policy">Duplicate Policy</option>
                                                    <option value="Technical Issues">Technical / System Issues</option>
                                                    <option value="Premium Too High">Premium Too High</option>
                                                    <option value="Personal Reasons">Personal Reasons</option>
                                                    <option value="Other">Other Reasons</option>
                                                </select>
                                            </div>
                                            <div class="info-hint">Primary reason for requesting cancellation</div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <!-- Effective Date -->
                                        <div class="form-group mb-4">
                                            <label for="effective_date" class="form-label required">
                                                <i class="fas fa-calendar-alt me-2"></i>Effective Date
                                            </label>
                                            <div class="date-input-wrapper">
                                                <input type="date" 
                                                       class="form-control datepicker" 
                                                       id="effective_date" 
                                                       name="effective_date" 
                                                       placeholder="Select cancellation effective date"
                                                       required>
                                                <span class="datepicker-icon"><i class="far fa-calendar"></i></span>
                                            </div>
                                            <div class="info-hint">Date when cancellation should take effect</div>
                                        </div>
                                        
                                        <!-- Additional Notes -->
                                        <div class="form-group mb-4">
                                            <label for="reason_notes" class="form-label">
                                                <i class="fas fa-sticky-note me-2"></i>Additional Notes
                                            </label>
                                            <textarea class="form-control" 
                                                      id="reason_notes" 
                                                      name="reason_notes"
                                                      placeholder="Optional: Provide additional details, comments, or specific circumstances..."
                                                      rows="4"></textarea>
                                            <div class="info-hint">Additional information about the cancellation (optional)</div>
                                        </div>
                                    </div>
                                </div>
                                
                                 
                                <!-- Submit Buttons -->
                                <div class="text-center mt-5">
                                    <button type="submit" name="submit_cancellation" value="1" class="btn cancel-btn">
                                        <i class="fas fa-ban me-2"></i> SUBMIT CANCELLATION REQUEST
                                    </button>
                                    <button type="reset" class="btn btn-outline-secondary ms-3" style="padding: 12px 35px; border-radius: 30px; font-size: 1.1em;">
                                        <i class="fas fa-redo me-2"></i> RESET FORM
                                    </button>
                                    <a href="javascript:history.back()" class="btn back-btn ms-3">
                                        <i class="fas fa-arrow-left me-2"></i> BACK TO SEARCH
                                    </a>
                                </div>
                            </form>
                            
                            <!-- Processing Information -->
                            <div class="info-panel mt-5">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <h5 class="mb-2">
                                            <i class="fas fa-info-circle me-2 text-primary"></i>
                                            Cancellation Processing Information
                                        </h5>
                                        <p class="mb-0">
                                            Cancellation requests are processed within <strong class="processing-time">1-3 business days</strong>. 
                                            Customer will receive confirmation via SMS and email once processed. 
                                            For urgent requests, please contact our customer service hotline.
                                        </p>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php elseif (isset($_POST['search_policy']) && empty($policy_details) && empty($error_message)): ?>
                        <!-- No Results Found -->
                        <div class="card form-card">
                            <div class="no-results">
                                <i class="fas fa-search-minus"></i>
                                <h4>No Policy Found</h4>
                                <p>No active policy found with the provided policy number.</p>
                                <div class="mt-4">
                                    <a href="" class="btn back-btn">
                                        <i class="fas fa-redo me-2"></i> TRY AGAIN
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Datepicker JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/js/bootstrap-datepicker.min.js"></script>
    
    <script>
    // Initialize datepicker
    $(document).ready(function() {
        $('.datepicker').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true,
            todayHighlight: true,
            startDate: new Date(),
            endDate: '+30d'
        });
    });
    
    // Form validation
    document.addEventListener('DOMContentLoaded', function() {
        // Auto-focus search field
        document.getElementById('policy_number').focus();
        
        // Cancellation form validation
        const cancellationForm = document.querySelector('form[method="POST"]:last-of-type');
        if (cancellationForm) {
            cancellationForm.addEventListener('submit', function(e) {
                const requestChannel = document.getElementById('request_channel');
                const cancellationReason = document.getElementById('cancellation_reason');
                const effectiveDate = document.getElementById('effective_date');
                const termsConfirmation = document.getElementById('terms_confirmation');
                
                // Validation messages
                const messages = [];
                
                if (!requestChannel.value) messages.push('Please select the request channel');
                if (!cancellationReason.value) messages.push('Please select a cancellation reason');
                if (!effectiveDate.value) messages.push('Please select an effective date');
                if (!termsConfirmation.checked) messages.push('You must agree to the cancellation terms');
                
                if (messages.length > 0) {
                    e.preventDefault();
                    alert('Please fix the following errors:\n\n' + messages.join('\n'));
                    return false;
                }
                
                // Final confirmation
                const policyNumber = document.querySelector('input[name="policy_number"][type="hidden"]').value;
                const policyholderName = document.querySelector('.policyholder-name').textContent;
                
                const confirmation = confirm(`⚠️ FINAL CANCELLATION CONFIRMATION ⚠️\n\nPolicy Number: ${policyNumber}\nPolicyholder: ${policyholderName}\n\nAre you absolutely sure you want to cancel this policy?\n\n✅ This action will:\n• Terminate all insurance coverage\n• Forfeit any unused premiums\n• Be irreversible once processed\n\nClick OK to proceed with cancellation.`);
                
                if (!confirmation) {
                    e.preventDefault();
                    return false;
                }
                
                return true;
            });
        }
        
        // Form reset handler
        document.querySelector('button[type="reset"]')?.addEventListener('click', function(e) {
            const confirmation = confirm('Are you sure you want to clear all form data?');
            if (!confirmation) {
                e.preventDefault();
            }
        });
    });
    </script>
    
    <!-- Include jQuery for datepicker -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</body>
</html>
<?php
// Close database connection
if (isset($con) && $con) {
    $con->close();
}
?>