<?php
//Connect to Database
include("database.php");
include('log_functions.php');	

session_start();

// Escape function for output
function escape($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

// Sanitize user inputs properly using prepared statements and additional filtering
$org_name       = htmlspecialchars(filter_var($_POST['org_name'], FILTER_SANITIZE_STRING));
$org_address    = htmlspecialchars(filter_var($_POST['org_address'], FILTER_SANITIZE_STRING));
$org_tel        = htmlspecialchars(filter_var($_POST['org_tel'], FILTER_SANITIZE_STRING));
$org_email      = htmlspecialchars(filter_var($_POST['org_email'], FILTER_SANITIZE_EMAIL)); // Changed to sanitize email
$org_website    = htmlspecialchars(filter_var($_POST['org_website'], FILTER_SANITIZE_URL)); // Changed to sanitize URL
$capturing_daten= htmlspecialchars(filter_var($_POST['capturing_date'], FILTER_SANITIZE_STRING)); 
$userindex      = htmlspecialchars(filter_var($_POST['userindex'], FILTER_SANITIZE_STRING));
$orgindexn      = htmlspecialchars(filter_var($_POST['orgindexn'], FILTER_SANITIZE_STRING));
$banner_image      = htmlspecialchars(filter_var($_POST['banner_image'], FILTER_SANITIZE_STRING));


// Date Format
$capturing_date = date("Y-m-d", strtotime($capturing_daten));
$inputdate = date("Y-m-d h:i:s");

// Uploading Documents securely
$structure = 'images';
$target_dir = $structure . "/";
$target_file = $target_dir . basename($_FILES['org_logo']['name']);

// Whitelist allowed file types for security
$allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];
$file_extension = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

$pic = $_FILES['org_logo']['name'];
if ($pic == '' || !in_array($file_extension, $allowed_extensions)) {
    $pic = $banner_image;
}

// Prepared Statement for Update
$query = "UPDATE company 
          SET company_name = ?, company_address = ?, company_tel = ?, company_email = ?, company_website = ?, 
              company_userindex = ?, company_inputdate = ?, company_logo = ?
          WHERE companyindex = ?";
$stmt = $con->prepare($query);
if (!$stmt) {
    die("Error preparing statement: " . $con->error);
}


// Bind parameters
$stmt->bind_param('sssssssss',$org_name, $org_address, $org_tel, $org_email, $org_website, $userindex, $capturing_date, $pic,$orgindexn);

// Execute statement and check for errors
if (!$stmt->execute()) {
    die("Error executing query: " . $stmt->error);
}

// Close the statement
$stmt->close();

// Call the log_failed_login function
$page_path = 'org_edit.php';
$reasons = 'Updated Successfully'.' ('.$org_name.')';
$data_inf = 'N/A';
log_failed_login($con, $userindex, $page_path, $reasons ,$data_inf);


// Secure file upload process
if (in_array($file_extension, $allowed_extensions)) {
    if (move_uploaded_file($_FILES['org_logo']['tmp_name'], $target_file)) {
        // File uploaded successfully
    } else {
        // Handle file upload error here
    }
}

// Redirect to the report page
header("Location: org_report.php?sr=016!b100&msg=10$202?c");
exit;
?>
