<?php 

//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);


//Connect to Database
include("database.php");
//session_start();
// Include the email function file
//require_once 'email_functions.php';
require_once 'sms_function.php';
//require_once('schedule_functions.php'); 



function escape($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

// Sanitize and validate input
$email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_STRING);

//echo $email;exit;

// Parameterized query to prevent SQL injection
$stmt = $con->prepare("SELECT * FROM users WHERE user_email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result_contact_num = $stmt->get_result();
$test_contact_num = $result_contact_num->fetch_assoc();

if (!$test_contact_num) {
  header("Location: login_password_recovery.php?msg=6");
  exit;
}

$recovery_name = $test_contact_num['user_surname'] . ' ' . $test_contact_num['user_othernames'];
$user_mobilen = $test_contact_num['user_mobile'];
$userindexc = $test_contact_num['userindex'];
$user_email = $test_contact_num['user_email'];

if (empty($userindexc)) {
    header("Location: login_password_recovery.php?msg=6");
    exit;
}

// Generate a random password
$password = mt_rand(10000, 99999);
$options = ['cost' => 11];
$hashedPassword = password_hash($password, PASSWORD_BCRYPT, $options);


$user_maxtime = 30; // Set maximum time for expiration in days
$currentDate = date("Y-m-d"); // Current date
$newEndDate = date("Y-m-d", strtotime("$currentDate + $user_maxtime days")); // Add the maximum time to the current date
//$user_resettime = date("Y-m-d H:i:s", strtotime("+1 day")); // Reset time for the next day

//echo $password.' '.$userindexc.' '.$userindex;exit;

// Update user password with a secure, prepared statement
$updateStmt = $con->prepare("UPDATE users SET user_password=?, user_changepassword='1', user_enddate=? WHERE userindex=?");
$updateStmt->bind_param("sss", $hashedPassword, $newEndDate, $userindexc);

if ($updateStmt->execute()) {
    //echo "Password updated successfully!";
} else {
    echo "Error updating password: " . $updateStmt->error;
}




// Email details
//$to = $user_email;
//$subject = "CCPA System Password Token";
//$message = "<h1>Hello</h1><p>Dear  $recovery_name Your OTP is   $password  Thank You.</p>";

// Call the sendEmail function
//$result = sendEmail($to, $subject, $message);


$user_id       = $userindexc;
$mobile_number = $user_mobilen;
//$message       = "Your OTP is 483920";
$message = "Dear $recovery_name, your OTP is $password. Thank you.";
$message_type = "OTP";

$result = sendHubtelSms(
    $con,
    $user_id,
    $mobile_number,
    $message,
    $message_type
);

if ($result['success']) {
    echo "SMS sent successfully";
} else {
    echo "SMS failed: " . $result['response'];
}


// Log the password reset action
$logStmt = $con->prepare("INSERT INTO users_logs (userindex, caption, logs_date, path) VALUES (?, ?, ?, ?)");
$logCaption = "Forget Password";
$logPath = "login_password_recovery_eng.php";
$logStmt->bind_param("isss", $userindexc, $logCaption, $currentDate, $logPath);
$logStmt->execute();

// Redirect to login page with message
header("Location: login.php?msg=22");

$updateStmt->close();
exit;

?>
