<?php 
//Connect to Database
include("database.php");
session_start();

// Include the encryption/decryption functions
include('crypto_functions.php');


ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);



function escape($string){
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}



// Date & Time
$date_time = date("Y-m-d h:i:s");

// Sanitize and validate inputs
$username = filter_input(INPUT_POST, 'username', FILTER_SANITIZE_STRING);
$password = filter_input(INPUT_POST, 'password', FILTER_SANITIZE_STRING);
$count = filter_input(INPUT_POST, 'ncount', FILTER_SANITIZE_NUMBER_INT);



// If count is empty, set it to 0
$count = $count ? $count : 0;

// Block when wrong password 3 times
$count_no = 1;
$count += $count_no;

if ($count > 3) {

// Encrypt the data
$encrypted = encrypt($count);
$encoded_string = urlencode($encrypted);

//header("Location: login_password_recovery.php?msg=5&ncount=$encoded_string");exit;

header("Location: login_timer.php?ncount=$encoded_string");exit;
}

// Encrypt the data
$data = $count;
$encrypted = encrypt($data);
$encoded_string = urlencode($encrypted);

// Use prepared statements to prevent SQL injection
$query = "SELECT * FROM users WHERE user_name = ?";
$stmt = mysqli_prepare($con, $query);
mysqli_stmt_bind_param($stmt, 's', $username);
mysqli_stmt_execute($stmt);
$result_login = mysqli_stmt_get_result($stmt);

// Check if user exists
if (mysqli_num_rows($result_login) == 0) {
    // Log failed login attempt
    $log_query = "INSERT INTO users_logs (userindex, caption, logs_date, path) 
                  VALUES (?, 'Wrong User Name Or Password', ?, 'login_eng.php')";
    $log_stmt = mysqli_prepare($con, $log_query);
    mysqli_stmt_bind_param($log_stmt, 'ss', $username, $date_time);
    mysqli_stmt_execute($log_stmt);
    
    header("Location: login.php?msg=1&ncount=$encoded_string");
    exit;
}

// Fetch user data
$test_login = mysqli_fetch_array($result_login);
$user_password_hash = $test_login['user_password'];
$userindex = $test_login['userindex'];
$full_name = $test_login['user_surname'] . ' ' . $test_login['user_othernames'];
$user_status = $test_login['user_status'];
$user_login_date = $test_login['user_login_date'];
$user_changepassword = $test_login['user_changepassword'];
$user_sub_priv = $test_login['user_sub_priv'];
$user_enddate = $test_login['user_enddate'];
$user_reg_date = $test_login['user_reg_date'];
//$branchindex = $test_login['user_branchindex'];
$lastPasswordChangeTime = $test_login['user_inputdate'];
//$user_departmentindex = $test_login['user_departmentindex'];
$user_branchindex = $test_login['user_branchindex'];
//$user_folder_path = $test_login['user_folder_path'];
//$user_branchindex = $test_login['user_branchindex'];





// Check user status and other conditions
if ($userindex == '') {
    // Log failed login attempt
    $log_query = "INSERT INTO users_logs (userindex, caption, logs_date, path) 
                  VALUES (?, 'Wrong User Name Or Password', ?, 'login_eng.php')";
    $log_stmt = mysqli_prepare($con, $log_query);
    mysqli_stmt_bind_param($log_stmt, 'ss', $userindex, $date_time);
    mysqli_stmt_execute($log_stmt);
    
    header("Location: login.php?msg=1&ncount=$encoded_string");  
    exit;
}


//echo $userindex.' '.$password,$user_password_hash;exit;


// Match password using password_verify
if (password_verify($password, $user_password_hash)) {
    $_SESSION["userindex"] = $userindex;
    $_SESSION["name"] = $full_name;
    $_SESSION["last_login_date"] = $user_login_date;
    $_SESSION["username"] = $username;
    $_SESSION["user_sub_priv"] = $user_sub_priv;
    $_SESSION["user_enddate"] = $user_enddate;
	$_SESSION["user_branchindex"] = $user_branchindex;
    //$_SESSION["user_departmentindex"] = $user_departmentindex;
    $_SESSION["user_folder_path"] = $user_folder_path;
    $_SESSION["full_name"] = $full_name;   
        
 
    
    // Encrypt the data
$data = $userindex;
$encrypted_userindex = encrypt($data);
$encoded_string = urlencode($encrypted_userindex);

  //Encrypt ID and check if password change is required
    if ($user_changepassword == '1') {
        // Log change password action
        $log_query = "INSERT INTO users_logs (userindex, caption, logs_date, path) 
                      VALUES (?, 'Change Password', ?, 'login_eng.php')";
        $log_stmt = mysqli_prepare($con, $log_query);
        mysqli_stmt_bind_param($log_stmt, 'ss', $userindex, $date_time);
        mysqli_stmt_execute($log_stmt);
        
        header("Location: login_changepassword.php?id=$encoded_string");
        exit;
    }


  
    // Check if the user's account is active
    if ($user_status != 'Active') {
        // Log inactive user status
        $log_query = "INSERT INTO users_logs (userindex, caption, logs_date, path) 
                      VALUES (?, 'User Status Inactive', ?, 'login_eng.php')";
        $log_stmt = mysqli_prepare($con, $log_query);
        mysqli_stmt_bind_param($log_stmt, 'ss', $userindex, $date_time);
        mysqli_stmt_execute($log_stmt);
        
        header("Location: login.php?msg=2&id=$encoded_string");
        exit;
}

 
// Check if the account has expired
    $curr_date = date("Y-m-d");
    if (strtotime($curr_date) >= strtotime($user_enddate)) {
        header("Location: login_changepassword.php?id=$encoded_string");
        exit;
    }

    
    
    // Redirect to the dashboard
    header("Location:dashboard.php?id=$encoded_string");exit;

    //echo $userindex.' '.$user_branchindex.' '.$full_name;exit;
    
} else {
    // Log failed login attempt
    $log_query = "INSERT INTO users_logs (userindex, caption, logs_date, path) 
                  VALUES (?, 'Login Failed', ?, 'login_eng.php')";
    $log_stmt = mysqli_prepare($con, $log_query);
    mysqli_stmt_bind_param($log_stmt, 'ss', $userindex, $date_time);
    mysqli_stmt_execute($log_stmt);
    
    header("Location: login.php?msg=1&ncount=$encoded_string");
    exit;
}
?>
