<?php
// Start session to handle CSRF tokens
session_start();

include 'login_main_menu.php';
//Connect to Database
include("database.php");


ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);



if (!defined('INPUT_REQUEST')) {
  define('INPUT_REQUEST', 0);
}

// Include the encryption/decryption functions
include('crypto_functions.php');

// Sanitize inputs
$msg = htmlspecialchars(filter_var(mysqli_real_escape_string($con, $_REQUEST['msg'] ?? ''), FILTER_SANITIZE_STRING));
$ncount = htmlspecialchars(filter_var(mysqli_real_escape_string($con, $_REQUEST['ncount'] ?? ''), FILTER_SANITIZE_STRING));

//decrypt
$ncount = decrypt($ncount);


// Initialize username for form field
$username = htmlspecialchars($_POST['username'] ?? '', ENT_QUOTES, 'UTF-8');
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no">
  <title>LOGIN</title>
  
  <!-- Favicon -->
  <link rel="apple-touch-icon" sizes="76x76" href="../assets/img/apple-icon.png">
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  
  <!-- CSS -->
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet">
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet">
<style>
       body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}

    .login-container {
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      padding: 20px;
    }
    
    .login-card {
      width: 100%;
      max-width: 500px;
    }
    
    .form-group {
      margin-bottom: 1.5rem;
    }
    
    .forgot-password {
      text-align: center;
      margin-top: 1rem;
    }
    
    .forgot-password a {
      color: #6ec1e4;
      text-decoration: none;
    }
    
    .forgot-password a:hover {
      text-decoration: underline;
    }
  </style>
</head>

<body>
<div class="login-container">
  <div class="login-card">
    <div class="card">
      <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
        <h4 class="card-title" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">LOGIN</h4>
        <p class="card-category" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">Enter User Credentials</p>
</div>
      
      <div class="card-body">
        <form id="form" name="form" method="post" action="login_eng.php" onSubmit="return validater(this)">
          <!-- Hidden fields -->
          <input type="hidden" name="msg" value="<?php echo $msg; ?>">
          <input type="hidden" name="ncount" value="<?php echo $ncount; ?>">
    
  <div class="card card-profile">
    <div class="card-avatar">
      <a href="#pablo">
        <img class="img" src="images/user_login.jpeg" />
     </a>
  </div>
   </div>
          <!-- Username Field -->
          <div class="form-group">
            <label class="bmd-label-floating">Username</label>
            <input type="text" class="form-control" name="username" 
                   value="<?php echo $username; ?>" autocomplete="username">
          </div>
          
          <!-- Password Field -->
          <div class="form-group">
            <label class="bmd-label-floating">Password</label>
            <input type="password" class="form-control" name="password" autocomplete="current-password">
          </div>
          
          <!-- Submit Button -->
          <div class="text-center">
            <button type="submit" class="btn btn-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
              Sign In
            </button>
          </div>
          
          <!-- Forgot Password Link -->
          <div class="forgot-password">
            <a href="login_password_recovery.php" >Forgot password?</a>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
 <!-- JavaScript -->
<script src="../assets/js/core/jquery.min.js"></script>
<script src="../assets/js/core/popper.min.js"></script>
<script src="../assets/js/core/bootstrap-material-design.min.js"></script>

<script type="text/javascript">
// Message handling
const messages = {
  "1": "Wrong User Name Or Password",
  "2": "User Access Is In-Active Contact The Administrator",
  "3": "Wrong User Name Or Password",
  "9": "Password Updated Successfully",
  "15": "Session Expired Kindly LogIn Again",
  "22": "PASSWORD TOKEN SENT TO EMAIL PROVIDED",
  "23": "SMS ALERT FAILED PLEASE TRY AGAIN",
  "24": "PASSWORD EXPIRED CONTACT SYSTEM ADMINISTRATOR"
};

window.onload = function() {
  const msg = "<?php echo $msg; ?>";
  if (msg && messages[msg]) {
    alert(messages[msg]);
  }
};

// Form validation
function validater(form) {
  if (form.username.value === "") {
    alert("Please Enter User Name");
    form.username.focus();
    return false;
  }

  if (form.password.value === "") {
    alert("Please Enter Password");
    form.password.focus();
    return false;
  }
  return true;
}
</script>

<script src="../assets/js/core/jquery.min.js"></script>
<script src="../assets/js/core/popper.min.js"></script>
<script src="../assets/js/core/bootstrap-material-design.min.js"></script>
<script src="../assets/js/plugins/perfect-scrollbar.jquery.min.js"></script>
<script src="../assets/js/plugins/moment.min.js"></script>
<script src="../assets/js/plugins/sweetalert2.js"></script>
<script src="../assets/js/plugins/jquery.validate.min.js"></script>
<script src="../assets/js/plugins/jquery.bootstrap-wizard.js"></script>
<script src="../assets/js/plugins/bootstrap-selectpicker.js"></script>
<script src="../assets/js/plugins/bootstrap-datetimepicker.min.js"></script>
<script src="../assets/js/plugins/jquery.dataTables.min.js"></script>
<script src="../assets/js/plugins/bootstrap-tagsinput.js"></script>
<script src="../assets/js/plugins/jasny-bootstrap.min.js"></script>
<script src="../assets/js/plugins/fullcalendar.min.js"></script>
<script src="../assets/js/plugins/jquery-jvectormap.js"></script>
<script src="../assets/js/plugins/nouislider.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/core-js/2.4.1/core.js"></script>
<script src="../assets/js/plugins/arrive.min.js"></script>
<script src="https://maps.googleapis.com/maps/api/js?key=YOUR_KEY_HERE"></script>
<script src="../assets/js/plugins/chartist.min.js"></script>
<script src="../assets/js/plugins/bootstrap-notify.js"></script>
<script src="../assets/js/material-dashboard.js?v=2.1.1" type="text/javascript"></script>
<script src="../assets/demo/demo.js"></script>
</body>
</html>