<?php
// get_life_list.php
header('Content-Type: application/json');

include("database.php");
date_default_timezone_set("Africa/Accra");

$life_type = isset($_GET['life_type']) ? trim($_GET['life_type']) : '';
$policyholder_id = isset($_GET['policyholder_id']) ? trim($_GET['policyholder_id']) : '';

if ($policyholder_id === '' || ($life_type !== 'SECONDARY' && $life_type !== 'BENEFICIARY')) {
  echo json_encode(['ok' => false, 'message' => 'Invalid request']);
  exit;
}

if ($life_type === 'SECONDARY') {
  $sql = "SELECT secondary_life_id AS id, full_name, relationship
          FROM secondary_lives
          WHERE policyholder_id = ?
          ORDER BY full_name ASC";
} else {
  $sql = "SELECT beneficiary_id AS id, full_name, relationship
          FROM beneficiaries
          WHERE policyholder_id = ?
          ORDER BY full_name ASC";
}

$stmt = $con->prepare($sql);
if (!$stmt) {
  echo json_encode(['ok' => false, 'message' => 'Prepare failed']);
  exit;
}

$stmt->bind_param("s", $policyholder_id);
$stmt->execute();
$res = $stmt->get_result();

$rows = [];
while ($r = $res->fetch_assoc()) {
  $rows[] = [
    'id' => $r['id'],
    'full_name' => $r['full_name'],
    'relationship' => $r['relationship']
  ];
}

$stmt->close();

echo json_encode(['ok' => true, 'rows' => $rows]);
