<?php
// Connect to Database
include("database.php");

// IMPORTANT: make sure $subscriptions_id is set before this point
// e.g. $subscriptions_id = $_GET['subscriptions_id'] ?? $_POST['subscriptions_id'] ?? '';


// ==============================
// Select subscription_main
// ==============================
$result_search = mysqli_query($con, "
    SELECT subscriptions_id,mobile_money_number,full_name,date_of_birth,gender,
    product_name,total_premium,momo_network,onboarding_channel
    FROM subscription_main 
    WHERE subscriptions_id = '$subscriptions_id'
");

if (!$result_search) {
    die("Query failed: " . mysqli_error($con));
}

$test_search = mysqli_fetch_array($result_search);

if (!$test_search) {
    die("Error: Data not found..");
}

$subscriptions_id     = trim($test_search['subscriptions_id']);
$mobile_money_number  = trim($test_search['mobile_money_number']);
$full_name            = trim($test_search['full_name']);
$date_of_birth        = trim($test_search['date_of_birth']);
$gender               = trim($test_search['gender']);
$product_name         = trim($test_search['product_name']);
$total_premium        = trim($test_search['total_premium']);
$momo_network         = trim($test_search['momo_network']);
$onboarding_channel   = trim($test_search['onboarding_channel']);


// ==============================
// Select product_index by product_name (Prepared)
// ==============================
$stmt = $con->prepare("
    SELECT product_index, product_name
    FROM product
    WHERE product_name = ?
");

if (!$stmt) {
    die("Prepare failed: " . $con->error);
}

$stmt->bind_param("s", $product_name);
$stmt->execute();

$result = $stmt->get_result();
if ($result->num_rows === 0) {
    die("Error: Product not found..");
}

$row = $result->fetch_assoc();
$product_index = trim($row['product_index']);
$stmt->close();


// ==============================
// Update policy_holders  ✅ FIXED (removed trailing comma)
// ==============================
mysqli_query($con, "
    UPDATE policy_holders
    SET
        momo_network = '$momo_network',
        product_index = '$product_index',
        set_premium = '$total_premium',
        onboarding_channel = '$onboarding_channel'
    WHERE subscriptions_id = '$subscriptions_id'
") or die(mysqli_error($con));


// ==============================
// Select policy_holders cust_id
// ==============================
$result_policy_holders = mysqli_query($con, "
    SELECT cust_id 
    FROM policy_holders 
    WHERE subscriptions_id = '$subscriptions_id'
");
if (!$result_policy_holders) {
    die("Query failed: " . mysqli_error($con));
}
$test_policy_holders = mysqli_fetch_array($result_policy_holders);
if (!$test_policy_holders) {
    die("Error: Policy holder not found..");
}
$cust_idn = trim($test_policy_holders['cust_id']);


// ==============================
// Update customer ✅ FIXED (removed trailing comma)
// ==============================
mysqli_query($con, "
    UPDATE customer
    SET
        full_name = '$full_name',
        date_of_birth = '$date_of_birth',
        gender = '$gender',
        mobile_money_number = '$mobile_money_number'
    WHERE cust_id = '$cust_idn'
") or die(mysqli_error($con));

?>
