<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include("database.php");
require_once("insert_into_maindb.php"); // contains processPolicySuccess()

$raw = file_get_contents("php://input");

// Log raw callback for debugging
file_put_contents(__DIR__ . "/hubtel_callback.log", date("c") . " " . $raw . PHP_EOL, FILE_APPEND);

// Try JSON first
$data = json_decode($raw, true);

// If not JSON, fall back to normal POST
if (!is_array($data)) {
    $data = $_POST;
}

// Extract ResponseCode
$ResponseCode = trim($data['ResponseCode'] ?? $data['responseCode'] ?? $data['response_code'] ?? '');

// Extract policy number (choose the key your Hubtel payload uses)
$policyNumberFromApi = trim(
    $data['policy_number'] ??
    $data['PolicyNumber'] ??
    $data['clientReference'] ??
    $data['description'] ??
    ''
);

// Always respond 200 (prevents retries)
http_response_code(200);

// If not success, stop
if ($ResponseCode !== '0000') {
    echo "OK";
    exit;
}

// If policy number missing, log and stop
if ($policyNumberFromApi === '') {
    file_put_contents(__DIR__ . "/hubtel_callback_errors.log", date("c") . " Missing policy number. Raw=" . $raw . PHP_EOL, FILE_APPEND);
    echo "OK";
    exit;
}

// Process success
$result = processPolicySuccess($con, $policyNumberFromApi, 'Success');

// Keep response short for gateway
if (!empty($result['success'])) {
    echo "OK";
} else {
    file_put_contents(__DIR__ . "/hubtel_callback_errors.log", date("c") . " " . ($result['message'] ?? 'Unknown error') . " Raw=" . $raw . PHP_EOL, FILE_APPEND);
    echo "OK";
}
?>