<?php
include("database.php");
//require_once('crypto_functions.php');
include('log_functions.php');	
session_start();

// Check user session for authentication
if (!isset($_SESSION['userindex'])) {
    die("Unauthorized access.");
}

// Escape output function
function escape($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

// Sanitize and validate inputs
$branch_name = filter_input(INPUT_POST, 'branch_name', FILTER_SANITIZE_STRING);
$branch_location = filter_input(INPUT_POST, 'branch_location', FILTER_SANITIZE_STRING);
$branch_contact = filter_input(INPUT_POST, 'branch_contact', FILTER_SANITIZE_STRING);
$branch_status = filter_input(INPUT_POST, 'branch_status', FILTER_SANITIZE_STRING);
$capturing_date = filter_input(INPUT_POST, 'capturing_date', FILTER_SANITIZE_STRING);
$userindex = $_SESSION['userindex']; // From session
$branch_code = filter_input(INPUT_POST, 'branch_code', FILTER_SANITIZE_STRING);
$branch_companyindex = filter_input(INPUT_POST, 'branch_companyindex', FILTER_SANITIZE_STRING);

//echo $branch_name.' '.$branch_location.' '.$branch_companyindex;exit;



// Insert into database securely using prepared statements
$stmt = $con->prepare("
    INSERT INTO branch (
        branch_name, 
        branch_location, 
        branch_contact, 
        branch_userindex, 
        branch_inputdate, 
        branch_companyindex
    ) VALUES (?, ?, ?, ?, ?, ?)
");
$inputdate = date("Y-m-d H:i:s"); // Format current date
$stmt->bind_param(
    "ssssss",
    $branch_name,
    $branch_location,
    $branch_contact,
    $userindex,
    $inputdate,
    $branch_companyindex
);

$data_inf = "Branch Name: $branch_name, "
         . "Location: $branch_location, "
         . "Contact: $branch_contact, "
         . "User: $userindex";

// Call the log_failed_login function
$page_path = 'branch_add.php';
$reasons = 'Add Successfully';
log_failed_login($con, $userindex, $page_path, $reasons , $data_inf);

// Execute the statement and handle errors securely
if ($stmt->execute()) {
    // Redirect on success
    header("Location: branch_add.php?sr=016!b101&msg=10$204?c");
    exit;
} else {
    // Log detailed error internally, but show generic error to the user
    error_log("Database error: " . $stmt->error);
    die("An error occurred while processing your request. Please try again later.");
}

$stmt->close();
?>
