<?php
// claims_management.php
session_start();
include("database.php");
include("session.php");

$date_from = isset($_REQUEST['date_from']) ? trim($_REQUEST['date_from']) : '';
$date_to = isset($_REQUEST['date_to']) ? trim($_REQUEST['date_to']) : '';


// Get all claims without filters
$query = "SELECT * FROM claims where claims_date between '$date_from' and '$date_to'  ORDER BY claims_date DESC";
$result = $con->query($query);

// Export to Excel functionality
if (isset($_GET['export']) && $_GET['export'] == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="claims_report_' . date('Y-m-d') . '.xls"');
    
    $output = '<table border="1">';
    $output .= '<tr>
        <th>Claim ID</th>
        <th>Policy Number</th>
        <th>Policyholder ID</th>
        <th>Life Type</th>
        <th>Claim Type</th>
        <th>Critical Illness Type</th>
        <th>Event Date</th>
        <th>Reported Date</th>
        <th>Sum Assured</th>
        <th>Approved Amount</th>
        <th>Claim Status</th>
        <th>Decision Notes</th>
        <th>Payout Mobile Money</th>
        <th>Payout Reference</th>
        <th>Claim Date</th>
    </tr>';
    
    while($row = $result->fetch_assoc()) {
        $output .= '<tr>';
        $output .= '<td>' . htmlspecialchars($row['claim_id']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['policy_number']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['policyholder_id']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['life_type']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['claim_type']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['critical_illness_type']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['event_date']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['reported_date']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['sum_assured']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['approved_amount']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['claim_status']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['decision_notes']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['payout_momo']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['payout_reference']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['claims_date']) . '</td>';
        $output .= '</tr>';
    }
    
    $output .= '</table>';
    echo $output;
    exit();
}

// Export to PDF functionality
if (isset($_GET['export']) && $_GET['export'] == 'pdf') {
    require_once('tcpdf/tcpdf.php');
    
    $pdf = new TCPDF('L', 'mm', 'A4', true, 'UTF-8');
    $pdf->SetCreator('Claims System');
    $pdf->SetAuthor('Insurance Company');
    $pdf->SetTitle('Claims Report');
    $pdf->SetHeaderData('', 0, 'Claims  Report', 'Generated on ' . date('Y-m-d H:i:s'));
    $pdf->setHeaderFont(Array('helvetica', '', 10));
    $pdf->setFooterFont(Array('helvetica', '', 8));
    $pdf->SetDefaultMonospacedFont('courier');
    $pdf->SetMargins(10, 20, 10);
    $pdf->SetHeaderMargin(5);
    $pdf->SetFooterMargin(10);
    $pdf->SetAutoPageBreak(TRUE, 15);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->AddPage();
    
    // PDF Header
    $html = '<h2 style="text-align:center;color:#6ec1e4;">Claims Management Report</h2>';
    $html .= '<p style="text-align:center;">All Claims - Generated on ' . date('F d, Y') . '</p>';
    
    // Table header
    $html .= '<table border="1" cellpadding="3">
        <tr style="background-color:#6ec1e4;color:white;font-weight:bold;">
            <th width="8%">Claim ID</th>
            <th width="10%">Policy No.</th>
            <th width="6%">PH ID</th>
            <th width="8%">Life Type</th>
            <th width="12%">Claim Type</th>
            <th width="8%">Event Date</th>
            <th width="8%">Sum Assured</th>
            <th width="8%">Approved Amt</th>
            <th width="8%">Status</th>
            <th width="10%">Payout MOMO</th>
            <th width="14%">Claim Date</th>
        </tr>';
    
    // Reset result pointer
    $result->data_seek(0);
    
    // Table rows
    while($row = $result->fetch_assoc()) {
        $status_color = '#28a745'; // Green for approved
        if ($row['claim_status'] == 'SUBMITTED') $status_color = '#ffc107'; // Yellow
        if ($row['claim_status'] == 'REJECTED') $status_color = '#dc3545'; // Red
        if ($row['claim_status'] == 'PENDING') $status_color = '#6c757d'; // Gray
        
        $html .= '<tr>';
        $html .= '<td>' . htmlspecialchars($row['claim_id']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['policy_number']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['policyholder_id']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['life_type']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['claim_type']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['event_date']) . '</td>';
        $html .= '<td>₵' . number_format($row['sum_assured'], 2) . '</td>';
        $html .= '<td>₵' . number_format($row['approved_amount'], 2) . '</td>';
        $html .= '<td style="background-color:' . $status_color . ';color:white;">' . htmlspecialchars($row['claim_status']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['payout_momo']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['claims_date']) . '</td>';
        $html .= '</tr>';
    }
    
    $html .= '</table>';
    
    // Add summary
    $result->data_seek(0);
    $total_claims = 0;
    $total_sum_assured = 0;
    $total_approved = 0;
    
    while($row = $result->fetch_assoc()) {
        $total_claims++;
        $total_sum_assured += $row['sum_assured'];
        $total_approved += $row['approved_amount'];
    }
    
    $html .= '<div style="margin-top: 20px; padding: 10px; background-color: #f8f9fa; border: 1px solid #dee2e6;">';
    $html .= '<h4 style="color: #6ec1e4;">Summary</h4>';
    $html .= '<p><strong>Total Claims:</strong> ' . $total_claims . '</p>';
    $html .= '<p><strong>Total Sum Assured:</strong> ₵' . number_format($total_sum_assured, 2) . '</p>';
    $html .= '<p><strong>Total Approved Amount:</strong> ₵' . number_format($total_approved, 2) . '</p>';
    $html .= '</div>';
    
    $pdf->writeHTML($html, true, false, true, false, '');
    $pdf->Output('claims_report_' . date('Ymd_His') . '.pdf', 'D');
    exit();
}

// Reset result pointer for HTML display
$result->data_seek(0);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Claims Management</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .card-header-primary {
            background: linear-gradient(135deg, #6ec1e4 0%, #2a8fc8 100%) !important;
            color: white !important;
        }
        .card-title {
            color: white !important;
            font-weight: bold !important;
        }
        .table-responsive {
            max-height: 600px;
            overflow-y: auto;
        }
        .export-btn {
            margin-right: 10px;
            font-weight: bold;
        }
        .status-badge {
            padding: 4px 10px;
            border-radius: 20px;
            font-size: 0.85em;
            font-weight: bold;
        }
        .status-approved {
            background-color: #d1fae5;
            color: #065f46;
            border: 1px solid #a7f3d0;
        }
        .status-submitted {
            background-color: #fef3c7;
            color: #92400e;
            border: 1px solid #fde68a;
        }
        .status-rejected {
            background-color: #fee2e2;
            color: #991b1b;
            border: 1px solid #fecaca;
        }
        .status-pending {
            background-color: #e5e7eb;
            color: #374151;
            border: 1px solid #d1d5db;
        }
        .amount-cell {
            font-weight: 600;
            text-align: right;
        }
        .summary-card {
            background: linear-gradient(135deg, #6ec1e4 0%, #2a8fc8 100%);
            color: white;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }
        .summary-value {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .summary-label {
            font-size: 14px;
            opacity: 0.9;
        }
        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
    <?php include 'main_menu_app.php'; ?>
<style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}


</style>
</head>
<body>
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">            
                    <div class="card-header card-header-primary" style="text-align: center; padding: 15px;">
                        <h4 class="card-title" style="color:white; font-weight: bold; text-align: center;">
                            <i class="fas fa-file-medical-alt"></i> CLAIMS
                        </h4>
                        <p class="card-category" style="color:white;">View and export all claims data</p>
                    </div>
                    
                    <div class="card-body">
                        <!-- Summary Cards -->
                        <?php 
                        $result->data_seek(0);
                        $total_claims = 0;
                        $total_sum_assured = 0;
                        $total_approved = 0;
                        $pending_claims = 0;
                        
                        while($row = $result->fetch_assoc()) {
                            $total_claims++;
                            $total_sum_assured += $row['sum_assured'];
                            $total_approved += $row['approved_amount'];
                            if ($row['claim_status'] == 'SUBMITTED' || $row['claim_status'] == 'PENDING') {
                                $pending_claims++;
                            }
                        }
                        $result->data_seek(0);
                        ?>
                        
                        <div class="row mb-4 no-print">
                            <div class="col-md-3">
                                <div class="summary-card">
                                    <div class="summary-value"><?php echo number_format($total_claims); ?></div>
                                    <div class="summary-label">Total Claims</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="summary-card" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%);">
                                    <div class="summary-value">₵<?php echo number_format($total_sum_assured, 2); ?></div>
                                    <div class="summary-label">Total Sum Assured</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="summary-card" style="background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);">
                                    <div class="summary-value">₵<?php echo number_format($total_approved, 2); ?></div>
                                    <div class="summary-label">Total Approved</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="summary-card" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);">
                                    <div class="summary-value"><?php echo number_format($pending_claims); ?></div>
                                    <div class="summary-label">Pending Claims</div>
                                </div>
                            </div>
                        </div>

                        <!-- Export Buttons -->
                        <div class="mb-3 no-print">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <a href="?export=excel" class="btn btn-success export-btn">
                                        <i class="fas fa-file-excel"></i> Export to Excel
                                    </a>
                                    <a href="?export=pdf" class="btn btn-danger export-btn">
                                        <i class="fas fa-file-pdf"></i> Export to PDF
                                    </a>
                                </div>
                                <div>
                                    <button onclick="window.print()" class="btn btn-secondary export-btn">
                                        <i class="fas fa-print"></i> Print Report
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Claims Table -->
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>Claim ID</th>
                                        <th>Policy Number</th>
                                        <th>Policyholder ID</th>
                                        <th>Life Type</th>
                                        <th>Claim Type</th>
                                        <th>Critical Illness</th>
                                        <th>Event Date</th>
                                        <th>Reported Date</th>
                                        <th class="text-end">Sum Assured</th>
                                        <th class="text-end">Approved Amount</th>
                                        <th>Status</th>
                                        <th>Decision Notes</th>
                                        <th>Payout MOMO</th>
                                        <th>Payout Ref</th>
                                        <th>Claim Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($result->num_rows > 0): ?>
                                        <?php while($row = $result->fetch_assoc()): 
                                            // Determine status class
                                            $status_class = 'status-pending';
                                            if ($row['claim_status'] == 'APPROVED') $status_class = 'status-approved';
                                            if ($row['claim_status'] == 'SUBMITTED') $status_class = 'status-submitted';
                                            if ($row['claim_status'] == 'REJECTED') $status_class = 'status-rejected';
                                        ?>
                                        <tr>
                                            <td><strong><?php echo htmlspecialchars($row['claim_id']); ?></strong></td>
                                            <td><?php echo htmlspecialchars($row['policy_number']); ?></td>
                                            <td><?php echo htmlspecialchars($row['policyholder_id']); ?></td>
                                            <td><?php echo htmlspecialchars($row['life_type']); ?></td>
                                            <td><?php echo htmlspecialchars($row['claim_type']); ?></td>
                                            <td><?php echo htmlspecialchars($row['critical_illness_type']); ?></td>
                                            <td><?php echo htmlspecialchars($row['event_date']); ?></td>
                                            <td><?php echo htmlspecialchars($row['reported_date']); ?></td>
                                            <td class="amount-cell">₵<?php echo number_format($row['sum_assured'], 2); ?></td>
                                            <td class="amount-cell">₵<?php echo number_format($row['approved_amount'], 2); ?></td>
                                            <td>
                                                <span class="status-badge <?php echo $status_class; ?>">
                                                    <?php echo htmlspecialchars($row['claim_status']); ?>
                                                </span>
                                            </td>
                                            <td title="<?php echo htmlspecialchars($row['decision_notes']); ?>">
                                                <?php 
                                                $notes = htmlspecialchars($row['decision_notes']);
                                                echo strlen($notes) > 30 ? substr($notes, 0, 30) . '...' : $notes;
                                                ?>
                                            </td>
                                            <td><?php echo htmlspecialchars($row['payout_momo']); ?></td>
                                            <td><?php echo htmlspecialchars($row['payout_reference']); ?></td>
                                            <td><?php echo htmlspecialchars($row['claims_date']); ?></td>
                                        </tr>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="15" class="text-center py-4">
                                                <div class="alert alert-info">
                                                    <i class="fas fa-info-circle"></i> No claims found in the system.
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Information -->
                        <div class="d-flex justify-content-between align-items-center mt-3 no-print">
                            <div>
                                Showing <strong><?php echo $result->num_rows; ?></strong> claims
                            </div>
                            <div>
                                <small class="text-muted">
                                    Generated on: <?php echo date('F d, Y H:i:s'); ?>
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php
// Close database connection
$con->close();
?>