<?php
// policy_payment_processing.php
session_start();
include("database.php");
include("session.php");

// Get filter parameters from URL
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : '';
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : '';
$policy_status = isset($_GET['policy_status']) ? $_GET['policy_status'] : 'Active';

// Build query with filters
$query = "SELECT * FROM policy_details_view WHERE policy_status = ?";
$params = [$policy_status];
$types = "s";

if (!empty($date_from)) {
    $query .= " AND DATE(created_at) >= ?";
    $params[] = $date_from;
    $types .= "s";
}

if (!empty($date_to)) {
    $query .= " AND DATE(created_at) <= ?";
    $params[] = $date_to;
    $types .= "s";
}

$query .= " ORDER BY created_at DESC";

// Prepare and execute query
$stmt = $con->prepare($query);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

// Export to Excel functionality
if (isset($_GET['export']) && $_GET['export'] == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="active_policies_' . date('Y-m-d') . '.xls"');
    
    $output = '<table border="1">';
    $output .= '<tr>
        <th>#</th>
        <th>Full Name</th>
        <th>Date of Birth</th>
        <th>Gender</th>
        <th>Mobile Money Number</th>
        <th>Policy Number</th>
        <th>MOMO Network</th>
        <th>Product Name</th>
        <th>Premium</th>
        <th>Onboarding Channel</th>
        <th>Policy Status</th>
        <th>Inception Date</th>
        <th>Created At</th>
    </tr>';
    
    $counter = 1;
    while($row = $result->fetch_assoc()) {
        $output .= '<tr>';
        $output .= '<td>' . $counter . '</td>';
        $output .= '<td>' . htmlspecialchars($row['full_name']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['date_of_birth']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['gender']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['mobile_money_number']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['policy_number']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['momo_network']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['product_name']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['set_premium']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['onboarding_channel']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['policy_status']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['inception_date']) . '</td>';
        $output .= '<td>' . htmlspecialchars($row['created_at']) . '</td>';
        $output .= '</tr>';
        $counter++;
    }
    
    $output .= '</table>';
    echo $output;
    exit();
}

// Export to PDF functionality
if (isset($_GET['export']) && $_GET['export'] == 'pdf') {
    require_once('tcpdf/tcpdf.php');
    
    $pdf = new TCPDF('L', 'mm', 'A4', true, 'UTF-8');
    $pdf->SetCreator('Policy System');
    $pdf->SetAuthor('Policy System');
    $pdf->SetTitle('Active Policies Report');
    $pdf->SetHeaderData('', 0, 'Active Policies Report', 'Generated on ' . date('Y-m-d H:i:s'));
    $pdf->setHeaderFont(Array('helvetica', '', 10));
    $pdf->setFooterFont(Array('helvetica', '', 8));
    $pdf->SetDefaultMonospacedFont('courier');
    $pdf->SetMargins(15, 25, 15);
    $pdf->SetHeaderMargin(5);
    $pdf->SetFooterMargin(10);
    $pdf->SetAutoPageBreak(TRUE, 25);
    $pdf->SetFont('helvetica', '', 10);
    $pdf->AddPage();
    
    // PDF Header
    $html = '<h2 style="text-align:center;color:#6ec1e4;">Active Policies Report</h2>';
    $html .= '<p style="text-align:center;">Date Range: ' . ($date_from ?: 'All') . ' to ' . ($date_to ?: 'All') . '</p>';
    
    // Table header
    $html .= '<table border="1" cellpadding="4">
        <tr style="background-color:#6ec1e4;color:white;font-weight:bold;">
            <th width="5%">#</th>
            <th width="11%">Full Name</th>
            <th width="7%">DOB</th>
            <th width="6%">Gender</th>
            <th width="10%">Mobile Money</th>
            <th width="10%">Policy No.</th>
            <th width="7%">Network</th>
            <th width="11%">Product</th>
            <th width="7%">Premium</th>
            <th width="9%">Channel</th>
            <th width="7%">Status</th>
            <th width="7%">Inception</th>
        </tr>';
    
    // Reset result pointer
    $result->data_seek(0);
    
    // Table rows
    $counter = 1;
    while($row = $result->fetch_assoc()) {
        $html .= '<tr>';
        $html .= '<td>' . $counter . '</td>';
        $html .= '<td>' . htmlspecialchars($row['full_name']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['date_of_birth']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['gender']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['mobile_money_number']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['policy_number']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['momo_network']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['product_name']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['set_premium']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['onboarding_channel']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['policy_status']) . '</td>';
        $html .= '<td>' . htmlspecialchars($row['inception_date']) . '</td>';
        $html .= '</tr>';
        $counter++;
    }
    
    $html .= '</table>';
    
    $pdf->writeHTML($html, true, false, true, false, '');
    $pdf->Output('active_policies_' . date('Y-m-d') . '.pdf', 'D');
    exit();
}

// Reset result pointer for HTML display
$result->data_seek(0);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Active Policies</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .card-header-primary {
            background: #6ec1e4 !important;
            color: white !important;
        }
        .card-title {
            color: #0a2cea !important;
            font-weight: bold !important;
        }
        .table-responsive {
            max-height: 500px;
            overflow-y: auto;
        }
        .export-btn {
            margin-right: 10px;
        }
        .serial-number {
            text-align: center;
            font-weight: bold;
        }
    </style>
    <?php include 'main_menu.php'; ?>
<style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}


</style>
</head>
<body>
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header card-header-primary">
                        <h4 class="card-title">Active Policies Report</h4>
                        <p class="card-category">View and export active policies</p>
                    </div>
                    <div class="card-body">
                        <!-- Export Buttons -->
                        <div class="mb-3">
                            <a href="?<?php echo http_build_query($_GET); ?>&export=excel" 
                               class="btn btn-success export-btn">
                                <i class="fas fa-file-excel"></i> Export to Excel
                            </a>
                            <a href="?<?php echo http_build_query($_GET); ?>&export=pdf" 
                               class="btn btn-danger export-btn">
                                <i class="fas fa-file-pdf"></i> Export to PDF
                            </a>
                        </div>

                        <!-- Policies Table -->
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead class="thead-dark">
                                    <tr>
                                        <th class="serial-number">#</th>
                                        <th>Full Name</th>
                                        <th>Date of Birth</th>
                                        <th>Gender</th>
                                        <th>Mobile Money</th>
                                        <th>Policy Number</th>
                                        <th>Network</th>
                                        <th>Product Name</th>
                                        <th>Premium</th>
                                        <th>Channel</th>
                                        <th>Status</th>
                                        <th>Inception Date</th>
                                        <th>Created At</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($result->num_rows > 0): 
                                        $counter = 1;
                                        while($row = $result->fetch_assoc()): ?>
                                        <tr>
                                            <td class="serial-number"><?php echo $counter; ?></td>
                                            <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                                            <td><?php echo htmlspecialchars($row['date_of_birth']); ?></td>
                                            <td><?php echo htmlspecialchars($row['gender']); ?></td>
                                            <td><?php echo htmlspecialchars($row['mobile_money_number']); ?></td>
                                            <td><?php echo htmlspecialchars($row['policy_number']); ?></td>
                                            <td><?php echo htmlspecialchars($row['momo_network']); ?></td>
                                            <td><?php echo htmlspecialchars($row['product_name']); ?></td>
                                            <td><?php echo htmlspecialchars($row['set_premium']); ?></td>
                                            <td><?php echo htmlspecialchars($row['onboarding_channel']); ?></td>
                                            <td>
                                                <span class="badge bg-success">
                                                    <?php echo htmlspecialchars($row['policy_status']); ?>
                                                </span>
                                            </td>
                                            <td><?php echo htmlspecialchars($row['inception_date']); ?></td>
                                            <td><?php echo htmlspecialchars($row['created_at']); ?></td>
                                        </tr>
                                        <?php 
                                        $counter++;
                                        endwhile; 
                                    else: ?>
                                        <tr>
                                            <td colspan="13" class="text-center">No policies found</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php
$stmt->close();
$con->close();
?>