<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

//Connect to Database
include("database.php");
	

$description = '01260000000005';
$responsestatus ='Success';
$status_input_date       = date("Y-m-d H:i:s");   
$policy_status = 'Active';
//====================================================

//Update subscription_main payment_status to success
//=====================================================
mysqli_query($con,"
    UPDATE subscription_main
    SET payment_status = '$responsestatus',
        status_input_date = '$status_input_date'
    WHERE policy_number = '$description'
") or die(mysqli_error($con));


//subscription_main and insert into customer
//===========================================
// Fetch subscription_main by policy_number (safe + clean)
// =====================================
$description = trim($description);

$stmtSubMain = $con->prepare("
    SELECT
        full_name,
        date_of_birth,
        gender,
        mobile_money_number,
        userindex,
        policy_number,
        product_name,
        total_premium,
        onboarding_channel,
        mandate_id,
        status_input_date,
        momo_network,
        subscriptions_id        
    FROM subscription_main
    WHERE TRIM(policy_number) = ?
    LIMIT 1
");

if (!$stmtSubMain) {
    die("Prepare failed: " . $con->error);
}

$stmtSubMain->bind_param("s", $description);
$stmtSubMain->execute();

$resultSubMain = $stmtSubMain->get_result();

if (!$resultSubMain || $resultSubMain->num_rows === 0) {
    die("Error 1: Data not found for policy_number = " . htmlspecialchars($description));
}

$sub = $resultSubMain->fetch_assoc();
$stmtSubMain->close();

// =====================================
// Customer details
// =====================================
$full_name           = $sub['full_name'];
$date_of_birth       = $sub['date_of_birth'];
$gender              = $sub['gender'];
$mobile_money_number = $sub['mobile_money_number'];
$userindex           = (int)$sub['userindex'];

// =====================================
// Policy holder details
// =====================================
$policy_number      = $sub['policy_number'];
$product_name       = $sub['product_name'];
$total_premium      = (float)$sub['total_premium'];
$onboarding_channel = $sub['onboarding_channel'];
$mandate_id         = $sub['mandate_id'];
$status_input_date  = $sub['status_input_date'];
$momo_network       = $sub['momo_network'];
$subscriptions_id   = (int)$sub['subscriptions_id'];



     
//insert if mobile number does not exit
//======================================
$stmtCheckCustomer = $con->prepare("
    SELECT cust_id, mobile_money_number
    FROM customer
    WHERE mobile_money_number = ?
    LIMIT 1
");
$stmtCheckCustomer->bind_param("s", $mobile_money_number);
$stmtCheckCustomer->execute();

$res = $stmtCheckCustomer->get_result();
$customerRow = $res->fetch_assoc();
$stmtCheckCustomer->close();

// If NOT found, set empty values (no crash)
$mobile_money_numbern = $customerRow ? trim($customerRow['mobile_money_number']) : '';
$cust_id              = $customerRow ? (int)$customerRow['cust_id'] : 0;



 

//if mobile_money_number exit or not
//===================================
if ($mobile_money_numbern == '') {
		
    // Insert into customer
    //================================
$stmt = $con->prepare("
    INSERT INTO customer
    (full_name, date_of_birth, gender, mobile_money_number, userindex)
    VALUES (?, ?, ?, ?, ?)
");
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
$stmt->bind_param(
    "ssssi",
    $full_name,
    $date_of_birth,
    $gender,
    $mobile_money_number,
    $userindex
);
if (!$stmt->execute()) {
    die("Insert failed: " . $stmt->error);
}

//Select the last record Cust_id
$cust_id = $con->insert_id;
	
} else {

//Select Cust_id
$result_custid = mysqli_query($con,"SELECT cust_id,mobile_money_number 
from customer where mobile_money_number = '$mobile_money_numbern' ");
$test_custid = mysqli_fetch_assoc($result_custid);
if (!$result_custid || mysqli_num_rows($result_custid) == 0) {
    die("Error: Data not found..");
}
$cust_id=trim($test_custid['cust_id']);
}
//========================================================





//loop subscription_main and Copy from subscription_main and Insert into policy_holders (create policy number)
//===============================================

    //get product index
      //=================================
$result_product = mysqli_query($con,"select product_index,product_name from product 
where product_name = '$product_name' ");
$test_product = mysqli_fetch_assoc($result_product);
if (!$result_product || mysqli_num_rows($result_product) == 0) {
    die("Error 3: Data not found..");
}
$product_index=trim($test_product['product_index']);




// Insert into policy_holders
// ==========================
$stmt = $con->prepare("
    INSERT INTO policy_holders
    (
        cust_id,
        momo_network,
        product_index,
        set_premium,
        mandate_id,
        onboarding_channel,
        policy_status,
        inception_date,
        userindex,
        subscriptions_id
    )
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

if (!$stmt) {
    die("Prepare failed: " . $con->error);
}

$stmt->bind_param(
    "issdssssii",
    $cust_id,            // int
    //$policy_number,      // string
    $momo_network,       // string
    $product_index,      // string
    $total_premium,      // double
    $mandate_id,         // string
    $onboarding_channel, // string
    $policy_status,      // string
    $status_input_date,  // string (Y-m-d H:i:s)
    $userindex,           // int
    $subscriptions_id
);

if (!$stmt->execute()) {
    die("Insert failed: " . $stmt->error);

}
//========================




//loop for policy_holders : policy id
//========================
$result_policyhol = mysqli_query($con,"select policyholder_id from policy_holders 
where subscriptions_id = '$subscriptions_id' ");
$test_policyhol = mysqli_fetch_assoc($result_policyhol);
if (!$result_policyhol || mysqli_num_rows($result_product) == 0) {
    die("Error 4: Data not found..");
}
$policyholder_id=trim($test_policyhol['policyholder_id']);



//loop Copy from subscription_additionallife  to secondary_lives
//===============================================
// Select additional lives
// ===============================
$stmtSelect = $con->prepare("
    SELECT
        mobile_money_number,
        full_name,
        date_of_birth,
        gender,
        relationship
    FROM subscription_additionallife
    WHERE subscriptions_id = ?
");

$stmtSelect->bind_param("i", $subscriptions_id);
$stmtSelect->execute();
$result = $stmtSelect->get_result();

while ($test_user = $result->fetch_assoc()) {

    $mobile_money_number = $test_user['mobile_money_number'];
    $full_name           = $test_user['full_name'];
    $date_of_birth       = $test_user['date_of_birth'];
    $gender              = $test_user['gender'];
    $relationship        = $test_user['relationship'];

    // ===============================
    // Calculate age at entry
    // ===============================
    $dob = new DateTime($date_of_birth);
    $age_at_entry = (new DateTime())->diff($dob)->y;
    $created_at = date('Y-m-d H:i:s');

    // ===============================
    // Insert into secondary_lives
    // ===============================
    $stmtInsert = $con->prepare("
        INSERT INTO secondary_lives
        (
            policyholder_id,
            full_name,
            relationship,
            date_of_birth,
            age_at_entry,
            created_at,
            userindex
        )
        VALUES (?, ?, ?, ?, ?, ?, ?)
    ");

    if (!$stmtInsert) {
        die("Prepare failed: " . $con->error);
    }

    $stmtInsert->bind_param(
        "isssisi",
        $policyholder_id,
        $full_name,
        $relationship,
        $date_of_birth,
        $age_at_entry,
        $created_at,
        $userindex
    );

    if (!$stmtInsert->execute()) {
        die("Insert failed: " . $stmtInsert->error);
    }

    $stmtInsert->close();
}

$stmtSelect->close();


//loop Copy from subscription_beneficiaries to beneficiaries
//===============================================
$stmt = $con->prepare("
    SELECT
        subscriptions_id,
        full_name,
        relationship,
        mobile_money_number,
        created_at
    FROM subscription_beneficiaries
    WHERE subscriptions_id = ?
");

$stmt->bind_param("i", $subscriptions_id);
$stmt->execute();
$result = $stmt->get_result();

while ($test_user = $result->fetch_assoc()) {

    $mobile_money_number = $test_user['mobile_money_number'];
    $full_name           = $test_user['full_name'];
    $relationship        = $test_user['relationship'];

    $created_at = date('Y-m-d H:i:s');

    $insertBeneficiary = $con->prepare("
        INSERT INTO beneficiaries
        (
            policyholder_id,
            full_name,
            relationship,
            mobile_money_number,
            created_at
        )
        VALUES (?, ?, ?, ?, ?)
    ");

    if (!$insertBeneficiary) {
        die("Prepare failed: " . $con->error);
    }

    $insertBeneficiary->bind_param(
        "issss",
        $policyholder_id,
        $full_name,
        $relationship,
        $mobile_money_number,
        $created_at
    );

    if (!$insertBeneficiary->execute()) {
        die("Insert failed: " . $insertBeneficiary->error);
    }

    $insertBeneficiary->close();
}
$stmt->close();

?>